/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.InChannel;
import jade.mtp.MTP;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.HTTPIO;
import jade.mtp.http.HTTPServer;
import jade.mtp.http.KeepAlive;
import jade.util.BasicProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageTransportProtocol
implements MTP {
    private static final int IN_PORT = 7778;
    private static final String OUT_PORT = "-1";
    private static final String PROXY_PORT = "1080";
    private static final String MAX_KA = "10";
    private static final String POLICY = "conservative";
    private static final String PREFIX = "jade_mtp_http_";
    private static final String TIMEOUT = "60000";
    private int numKA;
    private int outPort;
    private String proxyHost;
    private int proxyPort;
    private int timeout;
    private boolean policy;
    private boolean keepAlive = false;
    private boolean useProxy = false;
    private boolean useOutPort = false;
    private boolean useHttps = false;
    private String[] protocols = new String[]{"http", "https"};
    private String FIPA_NAME = "fipa.mts.mtp.http.std";
    private Hashtable addr2srv = new Hashtable();
    private KeepAlive ka;
    private Object lock = new Object();

    public TransportAddress strToAddr(String rep) throws MTPException {
        try {
            return new HTTPAddress(rep);
        }
        catch (MalformedURLException mue) {
            throw new MTPException("Address mismatch: this is not a valid HTTP address.");
        }
    }

    public String addrToStr(TransportAddress ta) throws MTPException {
        try {
            return ((HTTPAddress)ta).toString();
        }
        catch (Exception e) {
            throw new MTPException(e.toString());
        }
    }

    public String getName() {
        return this.FIPA_NAME;
    }

    public String[] getSupportedProtocols() {
        return this.protocols;
    }

    public TransportAddress activate(InChannel.Dispatcher disp) throws MTPException {
        try {
            return this.activate(disp, new ProfileImpl(new BasicProperties()));
        }
        catch (Exception e) {
            throw new MTPException(e.getMessage());
        }
    }

    public void activate(InChannel.Dispatcher disp, TransportAddress ta) throws MTPException {
        try {
            this.activate(disp, ta, new ProfileImpl(new BasicProperties()));
        }
        catch (Exception e) {
            throw new MTPException(e.getMessage());
        }
    }

    public TransportAddress activate(InChannel.Dispatcher disp, Profile p) throws MTPException {
        return this.activateServer(disp, null, p);
    }

    public void activate(InChannel.Dispatcher disp, TransportAddress ta, Profile p) throws MTPException {
        this.activateServer(disp, ta, p);
    }

    private TransportAddress activateServer(InChannel.Dispatcher disp, TransportAddress ta, Profile p) throws MTPException {
        int port = -1;
        boolean changePortIfBusy = false;
        String saxClass = null;
        HTTPAddress hta = null;
        try {
            if (ta != null) {
                hta = (HTTPAddress)ta;
            } else {
                try {
                    String tmp = p.getParameter("jade_mtp_http_port", null);
                    if (tmp != null) {
                        port = Integer.parseInt(tmp);
                    } else {
                        port = 7778;
                        changePortIfBusy = true;
                    }
                    hta = new HTTPAddress(InetAddress.getLocalHost().getCanonicalHostName(), port, this.useHttps);
                }
                catch (UnknownHostException ukhexc) {
                    throw new MTPException("Cannot activate MTP on default address: Unknown Host");
                }
                catch (MalformedURLException mexc) {
                    throw new MTPException("Cannot activate MTP on default address: Malformed URL");
                }
                catch (NumberFormatException nfexc) {
                    throw new MTPException("Cannot activate MTP on default address: Invalid port");
                }
            }
            port = hta.getPortNo();
            if (port <= 0 || port > 65535) {
                throw new MTPException("Invalid port number " + ta.getPort());
            }
            this.numKA = Integer.parseInt(p.getParameter("jade_mtp_http_numKeepAlive", MAX_KA));
            if (this.numKA > 0) {
                this.keepAlive = true;
                this.ka = new KeepAlive(this.numKA);
            }
            this.policy = p.getParameter("jade_mtp_http_policy", POLICY).equals("aggressive");
            this.outPort = Integer.parseInt(p.getParameter("jade_mtp_http_outPort", OUT_PORT));
            if (this.outPort != -1) {
                this.useOutPort = true;
            }
            this.proxyHost = p.getParameter("jade_mtp_http_proxyHost", null);
            if (this.proxyHost != null) {
                this.useProxy = true;
                this.proxyPort = Integer.parseInt(p.getParameter("jade_mtp_http_proxyPort", PROXY_PORT));
            }
            saxClass = p.getParameter("jade_mtp_http_parser", null);
            this.timeout = Integer.parseInt(p.getParameter("jade_mtp_http_timeout", TIMEOUT));
        }
        catch (ClassCastException cce) {
            throw new MTPException("User supplied transport address not supported.");
        }
        catch (NumberFormatException nexc) {
            throw new MTPException(nexc.getMessage());
        }
        try {
            HTTPServer srv = new HTTPServer(port, disp, this.numKA, saxClass, this.timeout, changePortIfBusy);
            int actualPort = srv.getLocalPort();
            if (actualPort != port) {
                hta = new HTTPAddress(InetAddress.getLocalHost().getCanonicalHostName(), actualPort, this.useHttps);
            }
            this.addr2srv.put(hta.toString(), srv);
            srv.start();
            return hta;
        }
        catch (Exception e) {
            throw new MTPException("While activating MTP got exception " + e);
        }
    }

    public void deactivate(TransportAddress ta) throws MTPException {
        HTTPServer srv = (HTTPServer)this.addr2srv.get(ta.toString());
        if (srv == null) {
            throw new MTPException("No server on address " + ta);
        }
        this.addr2srv.remove(ta.toString());
        srv.desactivate();
    }

    public void deactivate() throws MTPException {
        Enumeration it = this.addr2srv.keys();
        while (it.hasMoreElements()) {
            TransportAddress ta = (TransportAddress)it.nextElement();
            this.deactivate(ta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(String addr, Envelope env, byte[] payload) throws MTPException {
        HTTPAddress url = null;
        KeepAlive.KAConnection kac = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                byte[] request;
                block14: {
                    HTTPAddress host = new HTTPAddress(addr);
                    url = this.useProxy ? new HTTPAddress(this.proxyHost, this.proxyPort, false) : host;
                    String connPol = this.keepAlive ? "Keep-Alive" : "close";
                    StringBuffer boundary = new StringBuffer();
                    int i = 0;
                    while (i < 31) {
                        boundary.append(Integer.toString((int)Math.round(Math.random() * 15.0), 16));
                        ++i;
                    }
                    byte[] boundaryBytes = boundary.toString().getBytes("ISO-8859-1");
                    byte[] body = HTTPIO.createHTTPBody(env, boundaryBytes, payload);
                    byte[] header = HTTPIO.createHTTPHeader(host, body.length, connPol, boundaryBytes, this.useProxy);
                    ByteArrayOutputStream requestStream = new ByteArrayOutputStream(header.length + body.length);
                    requestStream.write(header);
                    requestStream.write(body);
                    requestStream.flush();
                    requestStream.close();
                    request = requestStream.toByteArray();
                    if (this.keepAlive) {
                        kac = this.ka.getConnection(url);
                        try {
                            if (kac != null && this.sendOut(kac, request, false) == 200) {
                                if (this.policy) {
                                    this.ka.swap(kac);
                                }
                                return;
                            }
                        }
                        catch (IOException ioe) {
                            if (kac == null) break block14;
                            kac.close();
                            this.ka.remove(kac);
                        }
                    }
                }
                Socket client = null;
                client = this.useOutPort ? new Socket(url.getHost(), url.getPortNo(), InetAddress.getLocalHost(), this.outPort) : new Socket(url.getHost(), url.getPortNo());
                kac = new KeepAlive.KAConnection(client, url);
                if (this.sendOut(kac, request, true) != 200) {
                    throw new MTPException("Description: ResponseMessage is not OK");
                }
            }
        }
        catch (Exception e) {
            if (kac != null) {
                kac.close();
            }
            if (this.keepAlive) {
                this.ka.remove(url);
            }
            throw new MTPException(e.getMessage());
        }
    }

    private int sendOut(KeepAlive.KAConnection kac, byte[] req, boolean newC) throws IOException {
        OutputStream os = kac.getOut();
        InputStream is = kac.getIn();
        HTTPIO.writeAll(os, req);
        StringBuffer typeConnection = new StringBuffer();
        int code = HTTPIO.getResponseCode(is, typeConnection);
        if (!"Keep-Alive".equals(typeConnection.toString())) {
            kac.close();
            if (!newC) {
                this.ka.remove(kac);
            }
        } else if (newC) {
            this.ka.add(kac);
        }
        return code;
    }
}

